// JavaScript Document
$(document).ready(function () {
	getInsuranceCompanyList();
});

function getInsuranceCompanyList()
{
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'admin/insurance_companies.php',
		data:{todo: 'getInsuranceCompanyList', page:$('#page').val(), search_text:$('#search_text').val()},
		dataType:"html",
		success:function (data) {
			$('#divInsuranceCompanyList').html(data);
		}
	});
}

function searchInsuranceCompanyList()
{
	$('#page').val(1)
 	getInsuranceCompanyList();
}

function clearInsuranceCompanySearch()
{
	$('#search_text').val('');
	$('#page').val(1)
 	getInsuranceCompanyList();	
}

function addEditInsuranceCompany(ic_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'admin/insurance_companies.php',
		data:{todo: 'addEditInsuranceCompany', ic_id:ic_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
		  /////////////////
			jQuery.validator.addMethod("checkUniqueInsuranceCompanyDescription", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'admin/insurance_companies.php',
								data: {todo:"checkUniqueInsuranceCompanyDescription", ic_name:value, ic_network_partner: $('#ic_network_partner').val(), ic_id: $('#ic_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
							});
					return resret;
				}
			}, "Insurance company with same name already exists in system. Please try another.");
			
			$("#frmAddEditInsuranceCompany").validate({
				rules: {
					debug: true,
					ic_network_partner:
					{
						required: true,
					},
					ic_name:
					{
						required: true,
						checkUniqueInsuranceCompanyDescription:true
					},
					evt_type_color:
					{
						required:true
					}
				},
				messages: {
					ic_network_partner:
					{
						required: "Please select network partner",
					},
					ic_name:
					{
						required: 'Please enter name'
					}
				}
			});
		}
	});
	
}

function saveInsuranceCompany()
{
	if($('#frmAddEditInsuranceCompany').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'admin/insurance_companies.php',
			data:$('#frmAddEditInsuranceCompany').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getInsuranceCompanyList();
					lobinotify('success', "Insurance company saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
