// JavaScript Document
$(document).ready(function () {

	$("#daterange").daterangepicker({
		ranges: {
			Yesterday: [moment().subtract("days", 1), moment().subtract("days", 1)],
			"Last 30 Days": [moment().subtract("days", 29), moment()],
			"This Month": [moment().startOf("month"), moment().endOf("month")]
		},
		startDate: moment().subtract("days", 29),
		endDate: moment(),
		opens: "left",
		cancelClass: "btn-danger",
		buttonClasses: ['btn', 'btn-sm']
	}, function (start, end) {
		var dateStr = start.format("MMMM D, YYYY") + " - " + end.format("MMMM D, YYYY");
		var dateStr1 = start.format("MM/DD/YYYY") + " - " + end.format("MM/DD/YYYY");
		$("#dateRange1").val(dateStr1);
		filterBy("custom");
		return $("#daterange .tab-title").html(dateStr);
	});

	getAppointmentPaymentList();
	filterBy('today');
	//////////////////
});

var formatted_date = function (date) 
{
	var m = ("0" + (date.getMonth() + 1)).slice(-2); // in javascript month start from 0.
	var d = ("0" + date.getDate()).slice(-2); // add leading zero 
	var y = date.getFullYear();
	return m + '/' + d + '/' + y;
}

function getAppointmentPaymentList() 
{
	let search_title = $("#search_title").val();
	let search_duepoint = $("#search_duepoint").val();
	let search_user = $('#search_user').val();	
	let search_client = $('#search_client').val();	
	let search_payment_mode = $("#search_payment_mode").val() ? $("#search_payment_mode").val() : "";

	let search_dateRange1 = $("#dateRange1").val();
	if (typeof search_dateRange1 === 'undefined'){
		search_dateRange1 = '';
	}
		
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'appointment_payments.php',
		data: { todo: 'getAppointmentPaymentList', search_title: search_title, search_duepoint: search_duepoint, search_user: search_user, 
				search_client: search_client, search_payment_mode: search_payment_mode, search_dateRange1: search_dateRange1,
				search_category: 'Appointment', action: $("#action").val(), page: $('#page').val() },
		dataType: "json",
		success: function (data) {

			$('#divAppointmentPaymentList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
			$("#all").removeClass("active");
			$("#today").removeClass("active");
			$("#week").removeClass("active");
			$("#month").removeClass("active");
			$("#daterange").removeClass("active");


			if (data.action == "")
				$("#all").addClass("active");
			else if (data.action == "today")
				$("#today").addClass("active");
			else if (data.action == "week")
				$("#week").addClass("active");
			else if (data.action == "month")
				$("#month").addClass("active");
			else
				$("#daterange").addClass("active");

			if (data.action !== 'custom') {
				$("#daterange .tab-title").html("Custom");
			}

		}
	});
}

function searchAppointmentPaymentList() 
{
	$('#page').val(1);
	getAppointmentPaymentList();
}

function clearAppointmentPaymentSearch() 
{
	$("#search_title").val('');
	$("#search_duepoint").val('');
	$('#search_user').val('');	
	$('#search_client').val('');	
	$("#search_payment_mode").val('');
	$('#dateRange1').val('');
	$('#action').val('');
	$('#page').val(1);
	getAppointmentPaymentList();
}

function filterBy(val) 
{
	if (val == 'week') {
		var curr_date = new Date();
		var day = curr_date.getDay();
		var diff = curr_date.getDate() - day + (day == 0 ? -6 : 1); // 0 for sunday
		var week_start_tstmp = curr_date.setDate(diff);
		var week_start = new Date(week_start_tstmp);
		var week_start_date = formatted_date(week_start);
		var week_end = new Date(week_start_tstmp);  // first day of week 
		week_end = new Date(week_end.setDate(week_end.getDate() + 6));
		var week_end_date = formatted_date(week_end);
		date = week_start_date + ' - ' + week_end_date;    // date range for current week

		$("#dateRange1").val(date);

	}
	else if (val == 'month') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), 1);

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth() + 1, 0);

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month
		$("#dateRange1").val(date);

	}
	else if (val == 'today') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month
		//console.log(date);
		$("#dateRange1").val(date);

	}

	$("#action").val(val);
	getAppointmentPaymentList();
}

function exportAppointmentPaymentsToPdf()
{
	var form = $(document.createElement('form'));
	$(form).attr("action", "appointment_payments.php");
	$(form).attr("method", "POST");
	$(form).attr("target", "_blank");

	let search_title = $("#search_title").val() ? $("#search_title").val() : "";
	let search_duepoint = $("#duepoint").val() ? $("#duepoint").val() : "";
	let search_user = $("#search_user").val() ? $("#search_user").val() : "";
	let search_client = $("#search_client").val() ? $("#search_client").val() : "";
	let search_payment_mode = $("#search_payment_mode").val() ? $("#search_payment_mode").val() : "";
	
	let search_dateRange1 = $("#dateRange1").val() ? $("#dateRange1").val() : "";
	
	let input1 = $("<input>").attr("type", "hidden")
							.attr("name", "search_title")
							.val(search_title);
	
	let input2 = $("<input>").attr("type", "hidden")
							.attr("name", "search_user")
							.val(search_user);
	
	let input3 = $("<input>").attr("type", "hidden")
							.attr("name", "search_client")
							.val(search_client);

	let input4 = $("<input>").attr("type", "hidden")
							.attr("name", "search_payment_mode")
							.val(search_payment_mode);
	
	let input5 = $("<input>").attr("type", "hidden")
							.attr("name", "search_duepoint")
							.val(search_duepoint);
	
	let input6 = $("<input>").attr("type", "hidden")
							.attr("name", "search_dateRange1")
							.val(search_dateRange1);

	var input7 = $("<input>").attr("type", "hidden")
					.attr("name", "todo")
					.val("exportAppointmentPaymentsToPdf");

	$(form).append($(input1));
	$(form).append($(input2));
	$(form).append($(input3));
	$(form).append($(input4));
	$(form).append($(input5));
	$(form).append($(input6));
	$(form).append($(input7));
	
	form.appendTo(document.body)
	$(form).submit();
	form.remove();
	
}