// JavaScript Document
var addr_fields = ["addr1", "addr2", "town", "county", "postcode"];
$(document).ready(function () {

	$("#daterange").daterangepicker({
		ranges: {
			Yesterday: [moment().subtract("days", 1), moment().subtract("days", 1)],
			"Last 30 Days": [moment().subtract("days", 29), moment()],
			"This Month": [moment().startOf("month"), moment().endOf("month")]
		},
		startDate: moment().subtract("days", 29),
		endDate: moment(),
		opens: "left",
		cancelClass: "btn-danger",
		buttonClasses: ['btn', 'btn-sm']
	}, function (start, end) {
		var dateStr = start.format("MMMM D, YYYY") + " - " + end.format("MMMM D, YYYY");
		var dateStr1 = start.format("MM/DD/YYYY") + " - " + end.format("MM/DD/YYYY");
		$("#dateRange1").val(dateStr1);
		filterBy("custom");
		return $("#daterange .tab-title").html(dateStr);
	});

	//getAppointmentList();
	filterBy('today');
	//////////////////
});

function getAppointmentList() 
{
	let search_title = $("#search_title").val();
	let search_duepoint = $("#search_duepoint").val();
	let search_user = $('#search_user').val();	
	let search_client = $('#search_client').val();	
	let search_status = $("#search_status").val() ? $("#search_status").val() : "";

	let search_dateRange1 = $("#dateRange1").val();
	if (typeof search_dateRange1 === 'undefined'){
		search_dateRange1 = '';
	}
		
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'appointments.php',
		data: { todo: 'getAppointmentList', search_title: search_title, search_duepoint: search_duepoint, search_user: search_user, 
				search_client: search_client, search_status: search_status, search_dateRange1: search_dateRange1,
				search_category: 'Appointment', action: $("#action").val(), page: $('#page').val() },
		dataType: "json",
		success: function (data) {

			$('#divAppointmentList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
			$("#all").removeClass("active");
			$("#today").removeClass("active");
			$("#week").removeClass("active");
			$("#month").removeClass("active");
			$("#daterange").removeClass("active");


			if (data.action == "")
				$("#all").addClass("active");
			else if (data.action == "today")
				$("#today").addClass("active");
			else if (data.action == "week")
				$("#week").addClass("active");
			else if (data.action == "month")
				$("#month").addClass("active");
			else
				$("#daterange").addClass("active");

			if (data.action !== 'custom') {
				$("#daterange .tab-title").html("Custom");
			}

		}
	});
}

function searchAppointmentList() 
{
	$('#page').val(1);
	getAppointmentList();
}

function clearAppointmentSearch() 
{
	$('#search_title').val('');
	$('#search_duepoint').val('');
	$('#search_user').val('');
	$('#search_client').val('');
	$("#search_status").val('')
	$('#dateRange1').val('');
	
	$('#action').val('');

	$('#page').val(1);
	getAppointmentList();
}

function addEditAppointment(evt_id) 
{
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'appointments.php',
		data: { todo: 'addEditAppointment', evt_id: evt_id },
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');

			$( '#task_owner' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $("#task_owner").parent(),
			} );
			$( '#fk_client_id' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $("#task_owner").parent(),
			} );
			$( '#fk_svc_id' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $("#task_owner").parent(),
			} );

			if($('#allow_weekends').val() == 0){
				$('#appointment_date').change(function() {
					var date = new Date($(this).val());
					const day = date.getDay();
					if(day == 0 || day == 6)
					{
						alert("Sorry, You can't select weekend to set appointment");
						$(this).val("");
					} 
				});
			}

			$.fn.modal.Constructor.prototype.enforceFocus = function () { };
			jQuery.validator.addMethod("checkCustomReminder", function( value, element ) {
				if(value != "" && $('#appointment_date').val() != '' && $('#start_time').val() != '')
				{
					let dt1 = value.toDate("dd/mm/yyyy hh:ii");
					let dt2 = ($('#appointment_date').val() + ' ' + $('#start_time').val()).toDate("dd/mm/yyyy hh:ii");
					let subsec = dt1 - dt2;
					if(subsec >= 0){
						return false;
					}else{
						return true;
					}
				}
			}, "Reminder date time must appear before start date time.");

			jQuery.validator.addMethod("checkUserAppointmentDateTime", function( value, element ) {
				var resret = null;
				let appointment_date = $('#appointment_date').val();
				let start_time = $('#start_time').val();
				let end_time = $('#end_time').val();
				let evt_id = $('#evt_id').val();
				console.log(value + ' -> ' + start_time + ' -> ' + end_time);
				if(appointment_date != '' &&  value != '' && start_time != '' && end_time != '')
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'appointments.php',
								data: {todo:"checkUserAppointmentDateTime", evt_id: evt_id, task_owner: value, appointment_date: appointment_date,
										start_time: start_time, end_time: end_time},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
										$('#task_owner-error').html('');
									}
								}
							});
					return resret;
				}else{
					return true;
				}
			}, "User has already appointment booked for given date and time. Please try another.");


			$("#frmAddEditAppointment").validate({
				ignore: [],
				rules: {
					debug: true,
					appointment_date:
					{
						required: true
					},
					task_owner:
					{
						required: true,
						checkUserAppointmentDateTime: true
					},
					fk_client_id:
					{
						required: true
					},
					evt_title:
					{
						required: true
					},
					start_time:
					{
						required: true
					},
					end_time:
					{
						required: true
					},
					reminder_datetime:
					{
						required: function(){ return ($('#evt_reminder_min').val() === 'Custom')},
						checkCustomReminder : function(){ return ($('#evt_reminder_min').val() === 'Custom')}
					}
				},
				messages: {
					appointment_date:
					{
						required: 'Please select appointment date'
					},
					task_owner:
					{
						required: 'Please select user to assign appointment'
					},
					fk_client_id:
					{
						required: 'Please select client'
					},
					evt_title:
					{
						required: 'Please enter title'
					},
					start_time:
					{
						required: 'Please enter start time'
					},
					end_time:
					{
						required: 'Please enter end time'
					},
					reminder_datetime:
					{
						required: "Please enter reminder date time"
					}
				}
			});
		}
	});

}

function saveAppointment() 
{
	if ($('#frmAddEditAppointment').valid()) {
		//alert($('#appointment_date').val());
		//check for start time and end time
		let start_time = parseInt($('#start_time').val().replace(':', ''));
		let end_time = parseInt($('#end_time').val().replace(':', ''));

		let bst = parseInt($('#break_start_at').val().replace(':', ''));
		let bet = parseInt($('#break_end_at').val().replace(':', ''));

		/*console.log(start_time);
		console.log(end_time);
		console.log(bst);
		console.log(bet);*/

		if((end_time - start_time) <= 0){
			alert('Start time must be less than end time');
			$('#start_time').focus();
			return false;
		} 

		if((start_time <= bst && end_time > bst &&  (end_time <= bet || end_time >= bet ))  
			|| (start_time > bst && start_time < bet) || (end_time > bst && end_time < bet) ){
			alert('Appointment time should not be between company break time');
			$('#start_time').focus();
			return false;
		}

		//return false;

		$('#btnSave1').hide();
		$('#btnWait1').show();
		$.ajax({
			type: 'POST',
			url: SYSLINK + 'appointments.php',
			data: $('#frmAddEditAppointment').serialize(),
			dataType: "json",
			success: function (data) {
				if (data.result == 'Success') {
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getAppointmentList();
					getCompanySmsCredit();
					lobinotify('success', "Appointment saved successfully.");
				}
				else {
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

function setTitle()
{
	if($('#fk_svc_id').val() > 0){
		let svctxt = $('#fk_svc_id option:selected').text();
		let apptitle = 'Appointment for ' + svctxt;
		$('#evt_title').val(apptitle);
	}
}
/*function deleteEvent(evt_id) 
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete Event?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type: "POST",
					url: SYSLINK + 'appointments.php',
					data: { todo: "deleteEvent", evt_id: evt_id },
					dataType: "json",
					success: function (data) {
						if (data.result == "Success") {
							$('#divModal').modal('hide');
							$('#divModal').html('');
							getAppointmentList();
							lobinotify('success', "Event deleted successfully.");
						}
						else {
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				});
			}
		}
	});
}*/

function triggerEndDate(fullDay) 
{
	if (fullDay.value == 1) {
		$('#block_evt_end_date_time').hide();
	}
	else {
		$('#block_evt_end_date_time').show();
	}
}

function updateAppointmentStatus(evt_id) 
{
	$.ajax({
		type: "POST",
		url: SYSLINK + 'appointments.php',
		data: { todo: "updateAppointmentStatus", evt_id: evt_id },
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
		}
	});

}

function saveAppointmentStatus() 
{
	$('#btnSave').hide();
	$('#btnWait').show();
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'appointments.php',
		data: $('#frmEditEventStatus').serialize(),
		dataType: "json",
		success: function (data) {
			if (data.result == 'Success') {
				$('#divModal').modal('hide');
				$('#divModal').html('');
				getAppointmentList();
				getCompanySmsCredit();
				lobinotify('success', "Appointment status saved sucessfully.");
				if(data.show_cash_flow == '1'){
					openAppointmentPayment(data.evt_id);
				}
			}
			else {
				lobinotify('error', "Sorry, some problem occurred while saving data.");
			}
		}
	});
}

function filterBy(val) 
{
	if (val == 'week') {
		var curr_date = new Date();
		var day = curr_date.getDay();
		var diff = curr_date.getDate() - day + (day == 0 ? -6 : 1); // 0 for sunday
		var week_start_tstmp = curr_date.setDate(diff);
		var week_start = new Date(week_start_tstmp);
		var week_start_date = formatted_date(week_start);
		var week_end = new Date(week_start_tstmp);  // first day of week 
		week_end = new Date(week_end.setDate(week_end.getDate() + 6));
		var week_end_date = formatted_date(week_end);
		date = week_start_date + ' - ' + week_end_date;    // date range for current week

		$("#dateRange1").val(date);

	}
	else if (val == 'month') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), 1);

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth() + 1, 0);

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month
		$("#dateRange1").val(date);

	}
	else if (val == 'today') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month
		//console.log(date);
		$("#dateRange1").val(date);

	}

	$("#action").val(val);
	getAppointmentList();
}



var formatted_date = function (date) 
{
	var m = ("0" + (date.getMonth() + 1)).slice(-2); // in javascript month start from 0.
	var d = ("0" + date.getDate()).slice(-2); // add leading zero 
	var y = date.getFullYear();
	return m + '/' + d + '/' + y;
}

function setCustomReminder()
{
	if($('#evt_reminder_min').val() == 'Custom'){
		$('#divCustomReminder').show();
	}else{
		$('#divCustomReminder').hide();
	}
}

function exportAppointmentsToPdf()
{
	var form = $(document.createElement('form'));
	$(form).attr("action", "appointments.php");
	$(form).attr("method", "POST");
	$(form).attr("target", "_blank");

	let search_title = $("#search_title").val() ? $("#search_title").val() : "";
	let search_duepoint = $("#duepoint").val() ? $("#duepoint").val() : "";
	let search_user = $("#search_user").val() ? $("#search_user").val() : "";
	let search_client = $("#search_client").val() ? $("#search_client").val() : "";
	let search_status = $("#search_status").val() ? $("#search_status").val() : "";
	
	let search_dateRange1 = $("#dateRange1").val() ? $("#dateRange1").val() : "";
	
	let input1 = $("<input>").attr("type", "hidden")
							.attr("name", "search_title")
							.val(search_title);
	
	let input2 = $("<input>").attr("type", "hidden")
							.attr("name", "search_user")
							.val(search_user);
	
	let input3 = $("<input>").attr("type", "hidden")
							.attr("name", "search_client")
							.val(search_client);

	let input4 = $("<input>").attr("type", "hidden")
							.attr("name", "search_status")
							.val(search_status);
	
	let input5 = $("<input>").attr("type", "hidden")
							.attr("name", "search_duepoint")
							.val(search_duepoint);
	
	let input6 = $("<input>").attr("type", "hidden")
							.attr("name", "search_dateRange1")
							.val(search_dateRange1);

	let input7 = $("<input>").attr("type", "hidden")
							.attr("name", "evt_category")
							.val('Appointment');

	var input8 = $("<input>").attr("type", "hidden")
					.attr("name", "todo")
					.val("exportAppointmentsToPdf");

	$(form).append($(input1));
	$(form).append($(input2));
	$(form).append($(input3));
	$(form).append($(input4));
	$(form).append($(input5));
	$(form).append($(input6));
	$(form).append($(input7));
	$(form).append($(input8));
	form.appendTo(document.body)
	$(form).submit();
	form.remove();
	
}

function openAppointmentPayment(evt_id, apay_id = 0)
{
	$.ajax({
		type: "POST",
		url: SYSLINK + 'appointments.php',
		data: { todo: "openAppointmentPayment", evt_id: evt_id, apay_id:apay_id },
		dataType: "html",
		success: function (data) {
			$('#divModal1').html(data);
			$('#divModal1').modal('show');

			$("#frmAppointmentPayment").validate({
				rules: {
					debug: true,
					apay_amount:
					{
						required: true,
						number: true
					}
				},
				messages: {
					apay_amount:
					{
						required: "Please enter amount"
					}
				}
			});
		}
	});	
}

function saveAppointmentPayment() 
{
	if ($('#frmAppointmentPayment').valid()) {
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type: 'POST',
			url: SYSLINK + 'appointments.php',
			data: $('#frmAppointmentPayment').serialize(),
			dataType: "json",
			success: function (data) {
				if (data.result == 'Success') {
					$('#divModal1').modal('hide');
					$('#divModal1').html('');
					getAppointmentList();
					lobinotify('success', "Payment data saved successfully.");

					console.log(data.print_data);
					if(data.print_data != ''){
						
						var wnd = window.open("about:blank", "", "_blank");
						wnd.document.write(data.print_data);
						wnd.print();
						
					}
				}
				else {
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
function checkPaymentMode()
{
	let pmode = $('#apay_type').val();
	if(pmode == 'Terms'){
		$('#divSendReceipt').hide();
	}else{
		$('#divSendReceipt').show();
	}
}

function printAppointment(evt_id)
{
    $.ajax({
        type: "POST",
        url: SYSLINK + 'appointments.php',
        data: { todo: "getAppointmentToPrint", evt_id: evt_id },
        dataType: "json",
        success: function (data) {
            if(data.company_name){
                print(data.company_name, data.company_tel, data.client_name, data.appointment_date, data.appointment_time)
            }
        }
    });
}

//Check JSPM WebSocket status
function jspmWSStatus() {
    //JSPM.JSPrintManager.auto_reconnect = true;
    //JSPM.JSPrintManager.start();
    if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Open)
        return true;
    else if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Closed) {
        alert('JSPrintManager (JSPM) is not installed or not running! Download JSPM Client App from https://neodynamic.com/downloads/jspm');
        return false;
    }
    else if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Blocked) {
        alert('JSPM has blocked this website!');
        return false;
    }
}

//Do printing...
function print(companyName, companyTel, clientName, appointmentDate, appointmentTime) {
    if (jspmWSStatus()) {
        //Create a ClientPrintJob
        var cpj = new JSPM.ClientPrintJob();
        //Set Printer type (Refer to the help, there many of them!)
        cpj.clientPrinter = new JSPM.DefaultPrinter();

        //Set content to print...
        // Create ESC/P commands for the label
        var esc = '\x1B'; // ESC byte in hex notation
        var newLine = '\x0A'; // LF byte in hex notation
        var gs = '\x1D'; // GS byte in hex notation (often used in ESC/POS, included for completeness but verify against manual if needed)
        var threeBackslashes = '\x5C\x5C\x5C'; // Three backslashes for end of 2D barcode/some 1D barcodes

        var cmds = ''; // Initialize an empty command string

        // 1. Switch to ESC/P mode (ESC i a 00h) - Page 89
        cmds += esc + '\x69' + '\x61' + '\x00';

        // 2. Initialize printer (ESC @) - Page 57
        cmds += esc + '\x40';

        // 3. Set character size to 48 dots (ESC X m nL nH) - Page 37
        // 48 decimal is 30h. nL = 30h, nH = 00h. m is irrelevant (00h).
        cmds += esc + '\x58' + '\x00' + '\x30' + '\x00';

        // 4. Print "Hello World !"
        cmds += companyName;



        // 5. Line Feed (LF) - Page 48
        cmds += newLine;

        cmds += clientName;

        // 5. Line Feed (LF) - Page 48
        cmds += newLine;

        cmds += 'Date: ' + appointmentDate;

        // 5. Line Feed (LF) - Page 48
        cmds += newLine;

        cmds += 'Time: ' + appointmentTime;

        // 5. Line Feed (LF) - Page 48
        cmds += newLine;

        cmds += companyTel;

        // 7. Line Feed (LF) - Page 48 (Optional spacing)
        cmds += newLine;

        // 9. Specify cutting (ESC i C 01h) - Page 93
        cmds += esc + '\x69' + '\x43' + '\x01';

        // 10. Page Feed (FF) - Page 48
        cmds += '\x0C';

        // Assign the complete command string to printerCommands
        cpj.printerCommands = cmds;
        //Send print job to printer!
        cpj.sendToClient();
    }
}