// JavaScript Document
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'bscat'){
		getBookshelfCategoryList();
	}
});

function getBookshelfCategoryList()
{
	var page = 1;
	if($('#page').length)
	{
		page = $('#page').val();	
	}	
	var search_bscat_desc =  $("#search_bscat_desc").val();
	if (typeof search_bscat_desc === 'undefined')
		var new_search_bscat_desc = '';
	else
		var new_search_bscat_desc = search_bscat_desc;

	var search_active =  $("#search_active").val();
	if (typeof search_active === 'undefined')
		var search_active = '';
	else
		var search_active = search_active;

	let search_bscat_user =  $("#search_bscat_user").val();
	let search_bscat_dt =  $("#search_bscat_dt").val();
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'bookshelf_categories.php',
		data:{todo: 'getBookshelfCategoryList',page:$('#page').val(),
					search_bscat_desc:new_search_bscat_desc, 
					search_bscat_user: search_bscat_user, search_bscat_dt:search_bscat_dt,
					search_active:search_active},
		dataType:"json",
		success:function (data) {
			$('#divBookshelfCategoryList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}

function searchBookshelfCategoryList()
{
	$('#page').val(1);
 	getBookshelfCategoryList();
}

function clearBookshelfCategorySearch()
{
	$('#search_bscat_desc').val('');
	$('#search_bscat_user').val('');
	$('#search_bscat_dt').val('');
	$('#page').val(1);
 	getBookshelfCategoryList();	
}
function addEditBookshelfCategory(bscat_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'bookshelf_categories.php',
		data:{todo: 'addEditBookshelfCategory', bscat_id:bscat_id},
		dataType: "html",
		success: function (data) {
			$('#divModal1').html(data);
			$('#divModal1').modal('show');
			
		  /////////////////
			jQuery.validator.addMethod("checkUniqueBookshelfCategoryDescription", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'bookshelf_categories.php',
								data: {todo:"checkUniqueBookshelfCategoryDescription", bscat_desc:value, bscat_id: $('#bscat_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "Bookshelf category with same name already exists in system. Please try another.");
			
			$("#frmAddEditBookshelfCategory").validate({
				rules: {
					debug: true,
					   bscat_desc:
					{
						required: true,
						checkUniqueBookshelfCategoryDescription:true
					}
				},
				messages: {
					bscat_desc:
					{
						required: 'Please enter bookshelf category description'
					}
				}
			});
		}
	});
	
}

function saveBookshelfCategory()
{
	if($('#frmAddEditBookshelfCategory').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'bookshelf_categories.php',
			data:$('#frmAddEditBookshelfCategory').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal1').modal('hide');
					$('#divModal1').html('');
					if($('.page-title-box').data("pg") === 'bscat'){
						getBookshelfCategoryList();
					}
					if($('.page-title-box').data("pg") === 'bsdoc'){
						let newOption = new Option(data.bscat, data.bscat_id, false, false);
						$('#fk_bscat_id').append(newOption).trigger('change');
						$('#fk_bscat_id').val(data.bscat_id).trigger('change');
						$('#btnSave').show();
						$('#btnWait').hide();
					}

					lobinotify('success', "Bookshelf category saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
					
				}
			}
		});
	}
}

