function addNewClient(val) 
{
	if(val !== 'new'){
		return false;
	}
	addr_fields = ["client_addr1", "client_addr2", "client_town", "client_county", "client_postcode"];
	$.ajax({
		type: 'POST',
		url: SYSLINK+'clients.php',
		data:{todo: 'addEditClient', client_id:0, module:'appointments'},
		dataType: "html",
		success: function (data) {
			$('#divModal1').html(data);
			$('#divModal1').modal('show');
			
			  //////////////////////////////
			jQuery.validator.addMethod("checkUniqueClient", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'clients.php',
								data: {todo:"checkUniqueClient", client_title: $('#client_title').val(), client_fname: $('#client_fname').val(),
										 client_lname: $('#client_lname').val(), client_addr1:value, client_postcode:$('#client_postcode').val(), 
										 client_id: $('#client_id').val()},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Client with same name and address already exists in system. Please try another.");
			$("#frmAddEditClient").validate({
				rules: {
					debug: true,
					client_title:{
						required: true
					},
					client_fname:{
						required: true,
					},
					client_lname:{
						required: true
					},
					client_email:{
						//required: true,
						email: true,
						//checkUniqueClientEmail: true
					},
					client_phone:{
						digits: true,
					},
					client_mobile:{
						//required: true,
						digits: true
					},
					client_addr1:{
						required: true,
						checkUniqueClient:true
					},
					client_town:{
						required: true
					},
					client_postcode:{
						required: true
					}
				},
				messages: {
					client_title:{
						required: "Please select title"
					},
					client_fname:{
						required: "Please enter first name"
					},
					client_lname:{
						required: "Please enter last name"
					},
					client_email:{
						required: "Please enter email"
					},
					client_mobile:{
						required: "Please enter mobile"
					},
					client_addr1:{
						required: "Please enter address1"
					},
					client_town:{
						required: "Please enter town"
					},
					client_postcode:{
						required: "Please enter postcode"
					}
				}
			});
		}
	});
}

function saveClient() 
{
	if ($('#frmAddEditClient').valid()) {
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type: 'POST',
			url: SYSLINK + 'clients.php',
			data: $('#frmAddEditClient').serialize(),
			dataType: "json",
			success: function (data) {
				if (data.result == 'Success') {
					$('#divModal1').modal('hide');
					$('#divModal1').html('');
					let newOption = new Option(data.client, data.client_id, false, false);
					$('#fk_client_id').append(newOption).trigger('change');
                    $('#fk_client_id').val(data.client_id).trigger('change');
				}
				else {
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}