// JavaScript Document
var addr_fields = [];
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'clientlist'){
		getClientList();
	}
});

function getClientList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');
	
	let search_client_name =  $("#search_client_name").val();
	let search_client_company_name =  $("#search_client_company_name").val();
	let search_client_address =  $("#search_client_address").val();
	let search_client_contact = $('#search_client_contact').val();
	let search_client_active = $('#search_client_active').val();

	$.ajax({
		type:'POST',
		url: SYSLINK+'clients.php',
		data:{todo: 'getClientList', search_client_name:search_client_name, search_client_company_name:search_client_company_name,
				search_client_address:search_client_address, search_client_contact:search_client_contact,
				search_client_active:search_client_active, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#divClientList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}

function searchClientList()
{
	$('#page').val(1);
 	getClientList();
}
function clearClientSearch()
{
	$("#search_client_name").val('');
	$("#search_client_company_name").val('');
	$("#search_client_address").val('');
	$("#search_client_contact").val('');
	$("#search_client_active").val('');
	$('#page').val(1);
	getClientList();	
}
function addEditClient(client_id)
{
	addr_fields = ["client_addr1", "client_addr2", "client_town", "client_county", "client_postcode"];
	$.ajax({
		type: 'POST',
		url: SYSLINK+'clients.php',
		data:{todo: 'addEditClient', client_id:client_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			  //////////////////////////////
			jQuery.validator.addMethod("checkUniqueClient", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'clients.php',
								data: {todo:"checkUniqueClient", client_title: $('#client_title').val(), client_fname: $('#client_fname').val(),
										 client_lname: $('#client_lname').val(), client_addr1:value, client_postcode:$('#client_postcode').val(), 
										 client_id: $('#client_id').val()},
								dataType:"json",
								success:function (data) {
		
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
							});
					return resret;
				}
			}, "Client with same name and address already exists in system. Please try another.");
			$("#frmAddEditClient").validate({
				rules: {
					debug: true,
					client_title:{
						required: true
					},
					client_fname:{
						required: true,
					},
					client_lname:{
						required: true
					},
					client_email:{
						//required: true,
						email: true,
						//checkUniqueClientEmail: true
					},
					client_phone:{
						digits: true,
					},
					client_mobile:{
						//required: true,
						digits: true
					},
					client_addr1:{
						required: true,
						checkUniqueClient:true
					},
					client_town:{
						required: true
					},
					client_postcode:{
						required: true
					}
				},
				messages: {
					client_title:{
						required: "Please select title"
					},
					client_fname:{
						required: "Please enter first name"
					},
					client_lname:{
						required: "Please enter last name"
					},
					client_email:{
						required: "Please enter email"
					},
					client_mobile:{
						required: "Please enter mobile"
					},
					client_addr1:{
						required: "Please enter address1"
					},
					client_town:{
						required: "Please enter town"
					},
					client_postcode:{
						required: "Please enter postcode"
					}
				}
			});
		}
	});
}

function saveClient()
{
	
	if($.trim($('#client_phone').val()) == '' && $.trim($('#client_mobile').val()) == ''){
		
		alert('Please enter either phone or mobile number');
		$('#client_phone').focus();
		return false;
	}

	if($('#client_sms_reminder').val() == '1' && $.trim($('#client_mobile').val()) == ''){
		
		alert('Please enter mobile number to send SMS reminder for client');
		$('#client_mobile').focus();
		return false;
	}

	if($('#frmAddEditClient').valid())
	{
		
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'clients.php',
			data:$('#frmAddEditClient').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					
					lobinotify('success', "Client data saved successfully.");
					
					if($('.page-title-box').data("pg") === 'clientlist'){
						getClientList();
					}else{
						location.reload();
					}
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}

/////////////////// Client Address ////////////////////////////
function getClientAppointmentHistoryList()
{
	let search_date =  $("#search_date").val();
	let search_user =  $("#search_user").val();
	let search_desc = $('#search_desc').val();
	

	$.ajax({
		type:'POST',
		url: SYSLINK+'client_view.php',
		data:{todo: 'getClientAppointmentHistoryList', fk_client_id:$('#client_id').val(), search_date:search_date, 
			search_user:search_user, search_desc:search_desc, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#divClientAppointmentHistoryList').html(data.list_html);
			$("#divClientAppointmentHistoryPagination").html(data.pagination_html);
		}
	});
}

function searchClientAppointmentHistoryList()
{
	$('#page').val(1);
	getClientAppointmentHistoryList();
}
function clearClientAppointmentHistoryList()
{
	$("#search_date").val('');
	$("#search_user").val('');
	$("#search_desc").val('');
	$('#page').val(1);
	getClientAppointmentHistoryList();	
}

function getClientAppointmentNoteList()
{
	let search_date =  $("#search_nt_date").val();
	let search_user =  $("#search_nt_user").val();
	let search_title = $('#search_nt_title').val();
	let search_note = $('#search_nt_note').val();

	$.ajax({
		type:'POST',
		url: SYSLINK+'client_view.php',
		data:{todo: 'getClientAppointmentNoteList', client_id:$('#client_id').val(), search_date:search_date, 
			search_user:search_user, search_title:search_title, search_note:search_note, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#divClientAppointmentNoteList').html(data.list_html);
			$("#divClientAppointmentNotePagination").html(data.pagination_html);
		}
	});
}

function searchClientAppointmentNoteList()
{
	$('#page').val(1);
	getClientAppointmentNoteList();
}
function clearClientAppointmentNoteList()
{
	$("#search_nt_date").val('');
	$("#search_nt_user").val('');
	$("#search_nt_title").val('');
	$("#search_nt_note").val('');
	$('#page').val(1);
	getClientAppointmentNoteList();	
}

function addEditClientNote(cln_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'client_view.php',
		data:{todo: 'addEditClientNote', cln_id:cln_id, client_id:$('#client_id').val()},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			//////////////////////////////
			
			$("#frmAddEditClientNote").validate({
				rules: {
					debug: true,
					cln_note:{
						required: true
					}
				},
				messages: {
					cln_note:{
						required: "Please enter note"
					}
				}
			});
		}
	});
}

function saveClientNote()
{
	if($('#frmAddEditClientNote').valid())
	{
		
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'client_view.php',
			data:$('#frmAddEditClientNote').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					
					lobinotify('success', "Client note saved successfully.");
					
					getClientAppointmentNoteList();
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}

function bulkImportClients()
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'clients.php',
		data:{todo: 'bulkImportClients'},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			//////////////////////////////
			
			$("#frmAddEditImportClient").validate({
				rules: {
					debug: true,
					cln_note:{
						required: true
					}
				},
				messages: {
					cln_note:{
						required: "Please enter note"
					}
				}
			});
		}
	});
}

function saveBulkClients()
{
	var frmCompanyLogo = $("#frmImportClient");
	var formData = new FormData($('#frmImportClient')[0]);
	$.ajax({
		type:'POST',
		url: SYSLINK+'clients.php',
		data:frmCompanyLogo,
		data: formData,
		mimeType:"multipart/form-data",
		processData: false,
		contentType: false,
		dataType:"json",
		success:function (data) {
			if(data.result == 'Success')
			{
				$('#divModal').modal('hide');
				$('#divModal').html('');
				getClientList();
				lobinotify('success', "Clients import was successfull.");

			}
			else
			{
				lobinotify('error', "Sorry, some problem occurred while saving data.");
			}
		}
	});
}