$(document).ready(function () {
	

	checkUserAccessToken();
	//getEmailList();
	$("#inboxEmail").change(function(){
		$(".checkbox1").prop('checked', $(this).prop("checked"));
	});

	$("#sentEmail").change(function(){
		$(".checkbox2").prop('checked', $(this).prop("checked"));
	});

	$("#trashEmail").change(function(){
		$(".checkbox3").prop('checked', $(this).prop("checked"));
	});
});

function checkUserAccessToken()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'checkUserAccessToken'},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Success'){
				refreshToken();
				
			}else{
				location.href = SYSLINK + 'ms_auth.php'
			}
		}
	});
}

function revokeSignInSessions()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'revokeSignInSessions'},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Success'){
				location.href = SYSLINK + 'ms_auth.php'
			}
		}
	});
}

function refreshToken()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'ms_token.php',
		data:{todo: 'refreshToken'},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Success'){
				getUnreadEmailCount();
				getEmailList();
			}else{
				lobinotify('error', "Sorry, your email token has been expired.")
				revokeSignInSessions();
			}
		}
	});
}

function reloadEmailList(){
	getEmailList();
}

function getEmailList()
{
	var page = 1;
	if($('#page').length)
	{
		page = $('#page').val();
	}
	var search_from =  $("#search_from").val();
	if (typeof search_from === 'undefined')
		var new_search_from = '';
	else
		var new_search_from = search_from;

	var search_subject =  $("#search_subject").val();
	if (typeof search_subject === 'undefined')
		var new_search_subject = '';
	else
		var new_search_subject = search_subject;
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getEmailList',page:$('#page').val(),search_from:new_search_from,search_subject:new_search_subject},
		dataType:"json",
		success:function (data) {
			$('#divEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link').val(data.next_link)
				$('#btnLoadMsg').show();
			}else{
				$('#next_link').val('');
				$('#btnLoadMsg').hide();
			}

		}
	});
}

function searchEmailList()
{
	$('#page').val(1);
	getEmailList();
}
function clearEmailSearch()
{
	$('#search_from').val('');
	$('#search_subject').val('');


	$('#page').val(1);
	getEmailList();
}

function loadMoreMsg()
{

	if($('#next_link').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextEmailList', next_link: $('#next_link').val()},
			dataType:"json",
			success:function (data) {
				$('#divEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link').val(data.next_link)
					$('#btnLoadMsg').show();
				}else{
					$('#next_link').val('');
					$('#btnLoadMsg').hide();
				}

			}
		});
	}
}

function getUnreadEmailCount()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getUnreadEmailCount'},
		dataType:"html",
		success:function (data) {
			$('#spnUnread').html('(' + data + ')');
		}
	});
}

function getSentEmailList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getSentEmailList'},
		dataType:"json",
		success:function (data) {
			$('#divSentEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link_sent').val(data.next_link)
				$('#btnLoadMsgSent').show();
			}else{
				$('#next_link_sent').val('');
				$('#btnLoadMsgSent').hide();
			}

		}
	});
}

function loadMoreMsgSent()
{

	if($('#next_link_sent').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextSentEmailList', next_link_sent: $('#next_link_sent').val()},
			dataType:"json",
			success:function (data) {
				$('#divSentEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link_sent').val(data.next_link)
					$('#btnLoadMsgSent').show();
				}else{
					$('#next_link_sent').val('');
					$('#btnLoadMsgSent').hide();
				}
			}
		});
	}
}

function getTrashEmailList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getTrashEmailList'},
		dataType:"json",
		success:function (data) {
			$('#divTrashEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link_sent').val(data.next_link)
				$('#btnLoadMsgSent').show();
			}else{
				$('#next_link_sent').val('');
				$('#btnLoadMsgSent').hide();
			}

		}
	});
}

function loadMoreMsgTrash()
{
	if($('#next_link_trash').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextTrashEmailList', next_link_trash: $('#next_link_trash').val()},
			dataType:"json",
			success:function (data) {
				$('#divTrashEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link_trash').val(data.next_link)
					$('#btnLoadMsgTrash').show();
				}else{
					$('#next_link_trash').val('');
					$('#btnLoadMsgTrash').hide();
				}
			}
		});
	}
}

function viewEmail(email_id, tr_id = '')
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'viewEmail', email_id: email_id},
		dataType:"html",
		success:function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			if($('#'+tr_id).data('isread') != '1'){
				updateEmailReadStatus(email_id, 1);
				$('#'+tr_id).css('font-weight', 'normal');
			}

		}
	});
}

function updateEmailReadStatus(email_id, read_status)
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'updateEmailReadStatus', email_id: email_id, is_read: read_status},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Success'){
				getUnreadEmailCount();
			}
		}
	});
}

function moveEmailToTrash(email_id, tr_id = '')
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete this message?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:'POST',
					url: SYSLINK+'emails.php',
					data:{todo: 'moveEmailToTrash', email_id: email_id},
					dataType:"json",
					success:function (data) {
						if(data.result === 'Success'){
							lobinotify('success', "Email moved to trash successfully.");
							$('#'+tr_id).remove();
						}
					}
				});
			}
		}
	});
}

function deleteEmail(email_id, tr_id = '')
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete this message? Once deleted, you wil not be able to restore it.",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:'POST',
					url: SYSLINK+'emails.php',
					data:{todo: 'deleteEmail', email_id: email_id},
					dataType:"json",
					success:function (data) {
						if(data.result === 'Success'){
							lobinotify('success', "Email deleted successfully.");
							$('#'+tr_id).remove();
						}
					}
				});
			}
		}
	});
}

function getDraftEmailList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getDraftEmailList'},
		dataType:"json",
		success:function (data) {
			$('#divDraftEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link_draft').val(data.next_link)
				$('#btnLoadMsgDraft').show();
			}else{
				$('#next_link_draft').val('');
				$('#btnLoadMsgDraft').hide();
			}

		}
	});
}

function loadMoreMsgDraft()
{

	if($('#next_link_draft').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextDraftEmailList', next_link_sent: $('#next_link_sent').val()},
			dataType:"json",
			success:function (data) {
				$('#divDraftEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link_draft').val(data.next_link)
					$('#btnLoadMsgDraft').show();
				}else{
					$('#next_link_draft').val('');
					$('#btnLoadMsgDraft').hide();
				}
			}
		});
	}
}

function getJunkEmailList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getJunkEmailList'},
		dataType:"json",
		success:function (data) {
			$('#divJunkEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link_junk').val(data.next_link)
				$('#btnLoadMsgJunk').show();
			}else{
				$('#next_link_junk').val('');
				$('#btnLoadMsgJunk').hide();
			}
		}
	});
}

function loadMoreMsgJunk()
{

	if($('#next_link_junk').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextJunkEmailList', next_link_junk: $('#next_link_junk').val()},
			dataType:"json",
			success:function (data) {
				$('#divJunkEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link_junk').val(data.next_link)
					$('#btnLoadMsgJunk').show();
				}else{
					$('#next_link_junk').val('');
					$('#btnLoadMsgJunk').hide();
				}
			}
		});
	}
}

function getArchiveEmailList()
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'getArchiveEmailList'},
		dataType:"json",
		success:function (data) {
			$('#divArchiveEmailList').html(data.list_html);
			if(data.next_link !== '' && data.next_link !== null){
				$('#next_link_archive').val(data.next_link)
				$('#btnLoadMsgArchive').show();
			}else{
				$('#next_link_archive').val('');
				$('#btnLoadMsgArchive').hide();
			}
		}
	});
}

function loadMoreMsgArchive()
{

	if($('#next_link_archive').val() != ''){
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:{todo: 'getNextArchiveEmailList', next_link_junk: $('#next_link_junk').val()},
			dataType:"json",
			success:function (data) {
				$('#divArchiveEmailList').append(data.list_html);

				if(data.next_link !== '' && data.next_link !== null ){
					$('#next_link_archive').val(data.next_link)
					$('#btnLoadMsgArchive').show();
				}else{
					$('#next_link_archive').val('');
					$('#btnLoadMsgArchive').hide();
				}
			}
		});
	}
}

function discardEmail(email_id, tr_id = '')
{
	Lobibox.confirm({
		msg: "Are you sure, you want to discard this message? Once discarded, you wil not be able to restore it.",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:'POST',
					url: SYSLINK+'emails.php',
					data:{todo: 'deleteEmail', email_id: email_id},
					dataType:"json",
					success:function (data) {
						if(data.result === 'Success'){
							lobinotify('success', "Email discarded successfully.");
							$('#'+tr_id).remove();
						}
					}
				});
			}
		}
	});

	
}

function moveEmailToInbox(email_id, tr_id = '')
{
	Lobibox.confirm({
		msg: "Are you sure, you want to move this message to Inbox?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:'POST',
					url: SYSLINK+'emails.php',
					data:{todo: 'moveEmailToInbox', email_id: email_id},
					dataType:"json",
					success:function (data) {
						if(data.result === 'Success'){
							lobinotify('success', "Email moved successfully.");
							$('#'+tr_id).remove();
						}
					}
				});
			}
		}
	});
}

function composeEmail(email_id, etype)
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'composeEmail', email_id: email_id, etype: etype},
		dataType:"html",
		success:function (data) {
			$('#divModal').html(data);
			
			$('#elog_email_text').summernote({height: 300, dialogsInBody: true});

			
			if(etype == 'compose' || etype == 'draft'){
				$('#divModal').modal('show');

				$( '#elog_project_id' ).select2( {
					theme: "bootstrap-5",
					width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
					placeholder: $( this ).data( 'placeholder' ),
					allowClear: Boolean($(this).data('allow-clear')),
					dropdownParent: $("#elog_project_id").parent(),
				} );
			}

			let buttons = $('.note-editor button[data-toggle="dropdown"]');
    
			buttons.each(function (index) { $(this).removeAttr("data-toggle").attr("data-bs-toggle", "dropdown"); });
			

			$("#frmComposeEmail").validate({
				rules: {
					debug: true,

					elog_email_to:
						{
							required: true
						},
					elog_subject:
						{
							required: true
						},
					elog_email_text:
						{
							required: true
						}

				},
				messages: {
					elog_email_to:
						{
							required: 'Please enter To Email'
						},
					elog_subject:
						{
							required: 'Please enter Email Subject'
						},
					elog_email_text:
						{
							required: 'Please enter Email Content'
						}
				}
			});

			$(function() {
				// grab the file input and bind a change event onto it
				$('#elog_attachment').bind("change", function() {
					// new html5 formdata object.
					var formData = new FormData();
					//for each entry, add to formdata to later access via $_FILES["file" + i]
					for (var i = 0, len = document.getElementById('elog_attachment').files.length; i < len; i++) {
						formData.append("elog_attachment" + i, document.getElementById('elog_attachment').files[i]);
					}
					formData.append('todo',"upload");
					formData.append('att_cnt',$("#att_cnt").val());
					//send formdata to server-side
					$.ajax({
						url: SYSLINK+'emails.php', // our php file
						type: 'post',
						data: formData,
						dataType: 'html', // we return html from our php file
						//data:{todo: 'upload'},
						async: true,
						processData: false,  // tell jQuery not to process the data
						contentType: false,   // tell jQuery not to set contentType
						success : function(data) {

							$('#upload-result').show();
							//$('#upload-result').append('<div class=""><p>File(s) uploaded successfully!</p><br />');
							$('#upload-result').append(data);
						},
						error : function(request) {
							console.log(request.responseText);
						}
					});
				});
			});
		}
	});
}

function checkCC()
{
	if($('#divCC').is(':visible'))
	{
		$('#divCC').hide();
		$('#elog_email_cc').val('');
	}else{
		$('#elog_email_cc').val('');
		$('#divCC').show();
	}
}

function checkBCC()
{
	if($('#divBCC').is(':visible'))
	{
		$('#divBCC').hide();
		$('#elog_email_bcc').val('');
	}else{
		$('#elog_email_bcc').val('');
		$('#divBCC').show();
	}
}

function removeFile(filename,pointer)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'removeFile', filename:filename, pointer:pointer},
		dataType: "json",
		success: function (data) {
			$( "#file"+data.pointer+"").remove();

		}
	});
}

function sendEmail(set_draft)
{
	if(set_draft === 1){
		$('#is_draft').val('1');
	}else{
		$('#is_draft').val('');
	}

	if($('#frmComposeEmail').valid())
	{
		//$('#btnSave').hide();
		//$('#btnWait').show();
		/*var frmComposeEmail = $("#frmComposeEmail");
        var formData = new FormData($('#frmComposeEmail')[0]);*/
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			/*data:frmComposeEmail,
            data: formData,*/
			data:$('#frmComposeEmail').serialize(),
			dataType:"json",
			//mimeType:"multipart/form-data",
			success:function (data) {
				//alert(data);
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					//getEmailList();
					if(set_draft === 1){
						lobinotify('success', "Email saved as draft.");
					}else{
						lobinotify('success', "Email sent successfully.");
					}
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}

function toggleCheckBoxes(aid, eid)
{
	if($.type(aid) === 'string'){
		if($('#'+aid).is(':checked')){
			$('#'+aid).prop('checked', false);
			$('input[name="'+eid+'"]').each(function(){
				$(this).prop('checked', false);
			});
		}else{
			$('#'+aid).prop('checked', true);
			$('input[name="'+eid+'"]').each(function(){
				$(this).prop('checked', true);
			});
		}
	}else{
		$('input[name="'+eid+'"]').each(function(){
			$(this).prop('checked', aid);
		});
	}
}

function clearAllMainCheckboxes()
{
	$('input[name="all_ids"]').each(function(){
		$(this).prop('checked', false);
	});
}

function selectedEmailAction(eact)
{
	var ctab = $('.nav-tabs .active').parent().data('id');

	var selectedEmail = new Array();
	//alert('input[name="'+ctab+'_email_ids[]"]:checked');
	$('input[name="'+ctab+'_email_ids[]"]:checked').each(function(){
		selectedEmail.push($(this).val())
	});

	//alert(selectedEmail.length);
	if(selectedEmail.length > 0){
		if(eact === 'read'){
			$.ajax({
				type:'POST',
				url: SYSLINK+'emails.php',
				data: {todo: 'markSelectedAsRead', email_ids: selectedEmail.join(',')},
				dataType:"json",
				success:function (data) {
					if(data.result == 'Success')
					{
						lobinotify('success', "Email marked as read successfully.");
						if(ctab == 'inbox'){
							location.reload();
						}else{
							$("a[href='#"+ctab+"']").click();
						}
					}
					else
					{
						lobinotify('error', "Sorry, some problem occurred while saving data.")
					}
				}
			});
		}

		if(eact === 'unread'){
			$.ajax({
				type:'POST',
				url: SYSLINK+'emails.php',
				data: {todo: 'markSelectedAsUnread', email_ids: selectedEmail.join(',')},
				dataType:"json",
				success:function (data) {
					if(data.result == 'Success')
					{
						lobinotify('success', "Email marked as unread successfully.");
						if(ctab == 'inbox'){
							location.reload();
						}else{
							$("a[href='#"+ctab+"']").click();
						}
					}
					else
					{
						lobinotify('error', "Sorry, some problem occurred while saving data.")
					}
				}
			});
		}

		if(eact === 'delete' && ctab != 'trash'){
			Lobibox.confirm({
				msg: "Are you sure, you want to delete selected messages?",
				callback: function ($this, type, ev) {
					if (type === "yes") {
						$.ajax({
							type:'POST',
							url: SYSLINK+'emails.php',
							data: {todo: 'moveSelectedToTrash', email_ids: selectedEmail.join(',')},
							dataType:"json",
							success:function (data) {
								if(data.result == 'Success')
								{
									lobinotify('success', "Email moved to trash successfully.");
									if(ctab == 'inbox'){
										location.reload();
									}else{
										$("a[href='#"+ctab+"']").click();
									}
								}
								else
								{
									lobinotify('error', "Sorry, some problem occurred while saving data.")
								}
							}
						});
					}
				}
			});
		}

		if(eact === 'delete' && ctab === 'trash'){
			Lobibox.confirm({
				msg: "Are you sure, you want to delete selected messages? Once deleted you won't be able to recover it",
				callback: function ($this, type, ev) {
					if (type === "yes") {
						$.ajax({
							type:'POST',
							url: SYSLINK+'emails.php',
							data: {todo: 'deleteSelectedMessages', email_ids: selectedEmail.join(',')},
							dataType:"json",
							success:function (data) {
								if(data.result == 'Success')
								{
									lobinotify('success', "Email has been deleted successfully.");
									$("a[href='#"+ctab+"']").click();
								}
								else
								{
									lobinotify('error', "Sorry, some problem occurred while saving data.");
								}
							}
						});
					}
				}
			});
		}
	}
}

function checkEmailAssignedToProject(email_id, etyp)
{
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'checkEmailAssignedToProject', email_id: email_id},
		dataType:"json",
		success:function (data) {
			if(data.result === 'Assigned'){
				Lobibox.confirm({
					msg: "This email is already assigned to some project. Are you sure, you want to assign it again?",
					callback: function ($this, type, ev) {
						if (type === "yes") {
							moveToProject(email_id,etyp);
						}
					}
				});				
			}else{
				console.log('in else');
				moveToProject(email_id, etyp);
			}
		}
	});
}

function moveToProject(email_id,etyp)
{
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'emails.php',
		data:{todo: 'moveToProject', email_id: email_id, etyp:etyp},
		dataType:"html",
		success:function (data) {
			$('#divModal1').html(data);
			$('#divModal1').modal('show');
			
			$( '.single-select' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $(".single-select").parent(),
			} );
			//$.fn.modal.Constructor.prototype.enforceFocus = function() {};

			$("#frmEmailToProject").validate({
				rules: {
					debug: true,
					fk_project_id:
					{
						required: true
					}
				},
				messages: {
					fk_project_id:
					{
						required: "Please select project"
					}
				}
			});
		}
	});
}

function assignEmailToProject()
{
	if($('#frmEmailToProject').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'emails.php',
			data:$('#frmEmailToProject').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal1').modal('hide');
					$('#divModal1').html('');
					
					lobinotify('success', "Email assigned to project successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}