// JavaScript Document
$(document).ready(function () {
	getEventList();
});

function getEventList()
{
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'event_timeline.php',
		data:{todo: 'getEventList'},
		dataType:"html",
		success:function (data) {
			$('#divEventTimelineList').html(data);
		}
	});
}
function searchEventList()
{
	$('#page').val(1)
 	getEventList();
}
function clearEventSearch()
{
	$('#search_text').val('');
 	getEventList();	
}
function addEditEvent(evt_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'event_timeline.php',
		data:{todo: 'addEditEvent', evt_id:evt_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			
			 $("#frmAddEditEvent").validate({
				rules: {
					debug: true,
					   
					evt_evt_type_id:
					{
						required: true
					},
					evt_title:
					{
						required: true
					},
					evt_start_date_time:
					{
						required: true
					},
					evt_end_date_time:
					{
						required: function(){if($('#evt_is_full_day').val() == '1'){return false}else{return true}},
						
					},
					
				},
				messages: {
					evt_evt_type_id:
					{
						required: 'Please select Event Type'
					},
					evt_title:
					{
						required: 'Please enter Event Title'
					},
					evt_start_date_time:
					{
						required: 'Please enter Event Start Date and Time'
					},
					evt_end_date_time:
					{
						required: 'Please enter Event End Date and Time'
					}
				}
			});
		}
	});
	
}

function saveEvent()
{
	if($('#frmAddEditEvent').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'event_timeline.php',
			data:$('#frmAddEditEvent').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getEventList();
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}
function deleteEvent(evt_id)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete Event?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:"POST",
					url: SYSLINK +'event_timeline.php',
					data:{todo:"deleteEvent",evt_id:evt_id},
					dataType:"json",
					success:function (data) {
						if(data.result == "Success")
						{
							$('#divModal').modal('hide');
							$('#divModal').html('');
							getEventList();
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				});
			}
		}
	});
}
function triggerEndDate(fullDay)
{
	if(fullDay.value==1)
	{
		$('#block_evt_end_date_time').hide();
	}
	else
	{
		$('#block_evt_end_date_time').show();
	}
}