// JavaScript Document
$(document).ready(function () {
	getEventTypeList();
});

function getEventTypeList()
{
	var page = 1;
	if($('#page').length)
	{
		page = $('#page').val();	
	}	
	var search_evt_type_desc =  $("#search_evt_type_desc").val();
	if (typeof search_evt_type_desc === 'undefined')
		var new_search_evt_type_desc = '';
	else
		var new_search_evt_type_desc = search_evt_type_desc;
	
	var search_color =  $("#search_color").val();
	if (typeof search_color === 'undefined')
		var new_search_color = '';
	else
		var new_search_color = search_color;
		
	$.ajax({
		type:'POST',
		url: SYSLINK+'event_type.php',
		data:{todo: 'getEventTypeList',page:$('#page').val(),search_evt_type_desc:new_search_evt_type_desc,search_color:new_search_color},
		dataType:"json",
		success:function (data) {
			console.log(data);
			$('#divEventTypeList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}
function searchEventTypeList()
{
	$('#page').val(1);
 	getEventTypeList();
}
function clearEventTypeSearch()
{
	$('#search_evt_type_desc').val('');
	$('#search_color').val('');
	
	
	$('#page').val(1);
 	getEventTypeList();	
}
function addEditEventType(evt_type_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'event_type.php',
		data:{todo: 'addEditEventType', evt_type_id:evt_type_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			//// Coloe Paletter ////
			 $('#colorpalette1').colorPalette()
			  .on('selectColor', function(e) {
				$('#evt_type_color').val(e.color);
			  });
		  /////////////////
			jQuery.validator.addMethod("checkUniqueEventTypeDescription", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'event_type.php',
								data: {todo:"checkUniqueEventTypeDescription", evt_type_desc:value, evt_type_id: $('#evt_type_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "Event Type Description Already Exist in system. Please try another.");
			
			$("#frmAddEditEventType").validate({
				rules: {
					debug: true,
					   evt_type_desc:
					{
						required: true,
						checkUniqueEventTypeDescription:true
					},
					evt_type_color:
					{
						required:true
					}
				},
				messages: {
					evt_type_desc:
					{
						required: 'Please enter Description'
					},
					evt_type_color:
					{
						required: 'Please enter Color'
					}
				}
			});
		}
	});
	
}

function saveEventType()
{
	if($('#frmAddEditEventType').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'event_type.php',
			data:$('#frmAddEditEventType').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getEventTypeList();
					lobinotify('success', "Event type saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.")
				}
			}
		});
	}
}
function deleteEventType(evt_type_id)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete Event Type?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:'POST',
					url: SYSLINK+'event_type.php',
					data:{todo: 'deleteEventType', evt_type_id:evt_type_id},
					dataType:"json",
					success:function (data) {
						if(data.result == 'Success')
						{
							getEventTypeList();
							lobinotify('success', "Event type deleted successfully.");
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.")
						}
					}
				});
			}
		}
	});
}

function changeEventTypeStatus(evt_type_id,status)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to change Event Type status?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:"POST",
					url: SYSLINK +'event_type.php',
					data:{todo:"changeEventTypeStatus",evt_type_id:evt_type_id,status:status},
					dataType:"json",
					success:function (data) {
						if(data.result == "Success")
						{
							getEventTypeList();
							lobinotify('success', "Event type status changed successfully.");
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				 });
			}
		}
	});
}