// JavaScript Document
var addr_fields = ["addr1", "addr2", "town", "county", "postcode"];
$(document).ready(function () {
	if($('.page-title-box').data("pg") === 'userlist'){
		getUsersList();
	}
	
});

function getUsersList()
{
	$('#refresh').html('<i class="icon-refresh"></i> Loading...');
	
	let search_name =  $("#search_name").val();
	let search_email =  $("#search_email").val();
	let search_address =  $("#search_address").val();
	let search_phone =  $("#search_phone").val();
	let search_mobile =  $("#search_mobile").val();
	let search_position =  $("#search_position").val();
	let search_role =  $("#search_role").val();
	let search_active =  $("#search_active").val();
	
	$.ajax({
		type:'POST',
		url: SYSLINK+'users.php',
		data:{todo: 'getUsersList',search_name:search_name, search_email:search_email, search_address:search_address,
			search_phone:search_phone, search_mobile:search_mobile, search_position: search_position,	  
			search_role:search_role, search_active:search_active, page:$('#page').val()},
		dataType:"json",
		success:function (data) {
			$('#refresh').html("");
			$('#divUserList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
		}
	});
}
function searchUserList()
{
	$('#page').val(1);
 	getUsersList();
}
function clearUserSearch()
{
	$("#search_name").val("");
	$("#search_email").val("");
	$("#search_address").val("");
	$("#search_phone").val("");
	$("#search_mobile").val("");
	$("#search_position").val("");
	$("#search_role").val("");
	$("#search_active").val("");
	$('#page').val(1);
	getUsersList();	
}
function addEditUser(user_id)
{
	$.ajax({
		type: 'POST',
		url: SYSLINK+'users.php',
		data:{todo: 'addEditUser', user_id:user_id},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');
			//var select = $('#user_title').select2();
			$('#user_title').select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $("#user_title").parent(),
			} );
			
			  $.fn.modal.Constructor.prototype.enforceFocus = function() {};
		  //////////////////////////////
			jQuery.validator.addMethod("checkUniqueUserEmail", function( value, element ) {
				var resret = null;
				if(value != "")
				{
					$.ajax({
								async: false,
								type:"POST",
								url:  SYSLINK +'users.php',
								data: {todo:"checkUniqueUserEmail", user_email:value, user_id: $('#user_id').val()},
								dataType:"json",
								success:function (data) {
		//							alert(data);return false;
									if(data.result == "Success")
									{
										resret = false;	
									}
									if(data.result == "Fail")
									{
										resret = true;	
									}
								}
								
								
							});
					return resret;
				}
			}, "Users Email Already Exist in system. Please try another.");
			$("#frmAddEditUser").validate({
				rules: {
					debug: true,
					   email:
					{
						required: true,
						email:true,
						checkUniqueUserEmail:true
					},
					title:
					{
						required: true
					},
					first_name:
					{
						required: true
					},
					last_name:
					{
						required: true
					},
					postcode:
					{
						required: true
					},
					addr1:
					{
						required: true
					},
					town:
					{
						required: true
					},
					phone:
					{
						number: true
					},
					mobile:
					{
						number: true,
					},
					fk_role_id:
					{
						required: true,
					}
				},
				messages: {
					email:
					{
						required: 'Please enter User Email'
					},
					title:
					{
						required: 'Please select Title'
					},
					first_name:
					{
						required: 'Please enter First Name'
					},
					last_name:
					{
						required: 'Please enter Last Name'
					},
					postcode:
					{
						required: 'Please enter Post Code'
					},
					addr1:
					{
						required: 'Please enter Address 1'
					},
					town:
					{
						required: 'Please enter Town'
					},
					fk_role_id:{
						required: "Please select role for user"
					}
				}
			});
		}
	});	
	
}

function saveUser()
{
	if($('#frmAddEditUser').valid())
	{
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type:'POST',
			url: SYSLINK+'users.php',
			data:$('#frmAddEditUser').serialize(),
			dataType:"json",
			success:function (data) {
				if(data.result == 'Success')
				{
					$('#divModal').modal('hide');
					$('#divModal').html('');
					if($('.page-title-box').data("pg") === 'userlist'){
						getUsersList();
					}else{
						getUserViewList();
					}
					
					lobinotify('success', "User saved successfully.");
				}
				else
				{
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}
function deleteUser(user_id)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete User?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:"POST",
					url: SYSLINK +'users.php',
					data:{todo:"deleteUser",user_id:user_id},
					dataType:"json",
					success:function (data) {
						if(data.result == "Success")
						{
							getUsersList();
							lobinotify('success', "User deleted successfully.");
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				 });
			}
		}
	});
}
function resetPassword(user_id)
{
	Lobibox.confirm({
		msg: "Are you sure, you want to reset user password?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type:"POST",
					url: SYSLINK +'users.php',
					data:{todo:"resetPassword",user_id:user_id},
					dataType:"json",
					success:function (data) {
						if(data.result == "Success")
						{
							$("#msg").attr("class","alert alert-success");
							$("#msg").html(' <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Successfully reset password');
							
							lobinotify('success', "User password has been reset successfully.");
						}
						else
						{
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				});
			}
		}
	});
}

function userAppointmentColor()
{
	$.ajax({
		type: "POST",
		url: SYSLINK + 'users.php',
		data: { todo: "userAppointmentColor"},
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');

			$('input[type=color]').each(function() {
				// Your code here
				$(this).spectrum(
					{
						preferredFormat: "hex",
						showInput: true,
					}
				);
			});
		}
	});

}

function saveUserAppointmentColor(rid)
{
	$('#btnSave'+rid).hide();
	$('#btnWait'+rid).show();
	$.ajax({
		type: "POST",
		url: SYSLINK + 'users.php',
		data: { todo: "saveUserAppointmentColor", user_id:rid, user_evt_back_color:$('#user_evt_back_color_' + rid).val(), user_evt_text_color:$('#user_evt_text_color_' + rid).val() },
		dataType: "json",
		success: function (data) {
			if(data.result == 'Success'){
				lobinotify('success', "User appointment color saved successfully.");
			}

			$('#btnWait'+rid).hide();
			$('#btnSave'+rid).show();
		}
	});
}