// JavaScript Document
var addr_fields = ["addr1", "addr2", "town", "county", "postcode"];
$(document).ready(function () {

	$("#daterange").daterangepicker({
		ranges: {
			Yesterday: [moment().subtract("days", 1), moment().subtract("days", 1)],
			"Last 30 Days": [moment().subtract("days", 29), moment()],
			"This Month": [moment().startOf("month"), moment().endOf("month")]
		},
		startDate: moment().subtract("days", 29),
		endDate: moment(),
		opens: "left",
		cancelClass: "btn-danger",
		buttonClasses: ['btn', 'btn-sm']
	}, function (start, end) {
		var dateStr = start.format("MMMM D, YYYY") + " - " + end.format("MMMM D, YYYY");
		var dateStr1 = start.format("MM/DD/YYYY") + " - " + end.format("MM/DD/YYYY");
		$("#dateRange1").val(dateStr1);
		filterBy("custom");
		return $("#daterange .tab-title").html(dateStr);
	});

	getWorkDiaryList();
	//////////////////
});

function getWorkDiaryList() 
{
	$('#DataTables_Table_1_filter').html('<i class="icon-refresh"></i> Loading...');
	var page = 1;
	var search_project = $("#search_project").val();
	if (typeof search_project === 'undefined')
		var new_search_project = '';
	else
		var new_search_project = search_project;

	var search_task_name = $("#task_name").val();
	if (typeof task_name === 'undefined')
		var new_task_name = '';
	else
		var new_search_task_name = search_task_name;

	var search_event_type = $("#search_event_type").val();
	if (typeof search_event_type === 'undefined')
		var new_search_event_type = '';
	else
		var new_search_event_type = search_event_type;


	var search_duepoint = $("#duepoint").val();
	if (typeof search_duepoint === 'undefined')
		var new_search_duepoint = '';
	else
		var new_search_duepoint = search_duepoint;


	var search_dateRange1 = $("#dateRange1").val();
	if (typeof search_dateRange1 === 'undefined')
		var new_search_dateRange1 = '';
	else
		var new_search_dateRange1 = search_dateRange1;

	let search_status = $("#search_status").val() ? $("#search_status").val() : "";

	$.ajax({
		type: 'POST',
		url: SYSLINK + 'work_diary.php',
		data: { todo: 'getWorkDiaryList', search_project: search_project, search_event_type: new_search_event_type, 
						search_dateRange1: new_search_dateRange1, search_duepoint: new_search_duepoint, 
						search_task_name: new_search_task_name, search_status: search_status,
						 action: $("#action").val(), page: $('#page').val() },
		dataType: "json",
		success: function (data) {

			$('#divWorkDiaryList').html(data.list_html);
			$("#divPagination").html(data.pagination_html);
			$('#DataTables_Table_1_filter').html("");
			$("#all").removeClass("active");
			$("#today").removeClass("active");
			$("#week").removeClass("active");
			$("#month").removeClass("active");
			$("#daterange").removeClass("active");


			if (data.action == "")
				$("#all").addClass("active");
			else if (data.action == "today")
				$("#today").addClass("active");
			else if (data.action == "week")
				$("#week").addClass("active");
			else if (data.action == "month")
				$("#month").addClass("active");
			else
				$("#daterange").addClass("active");

			if (data.action !== 'custom') {
				$("#daterange .tab-title").html("Custom");
			}

		}
	});
}

function searchWorkDiaryList() 
{
	$('#page').val(1);
	getWorkDiaryList();
}

function clearWorkDiarySearch() 
{
	$('#search_project').val('');
	$('#search_event_type').val('');
	$('#duepoint').val('');
	$('#dateRange1').val('');
	$('#task_name').val('');
	$('#action').val('');

	$('#page').val(1);
	getWorkDiaryList();
}

function addEditEvent(evt_id) 
{
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'work_diary.php',
		data: { todo: 'addEditEvent', evt_id: evt_id },
		dataType: "html",
		success: function (data) {
			$('#divModal').html(data);
			$('#divModal').modal('show');

			$( '.single-select' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
				dropdownParent: $(".single-select").parent(),
			} );

			$( '.multiple-select' ).select2( {
				theme: "bootstrap-5",
				width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
				placeholder: $( this ).data( 'placeholder' ),
				allowClear: Boolean($(this).data('allow-clear')),
			} );


			//var select = $('#fk_project_id').select2();
			//var select = $('#task_owner').select2();

			$('#start_date_time').bootstrapMaterialDatePicker({
				format: 'DD/MM/YYYY HH:mm'
			});

			$('#reminder_datetime').bootstrapMaterialDatePicker({
				format: 'DD/MM/YYYY HH:mm'
			});

			/*$('#start_date_time').datetimepicker({
				dayOfWeekStart: 1,
				lang: 'en',
				formatTime: 'h:i A',
				format: 'd/m/Y h:i A',
				formatDate: 'Y/m/d',
				minDate: 0,
				beforeShow: function (textbox, instance) {
					instance.dpDiv.css({
						marginTop: (-textbox.offsetHeight) + 'px',
						marginLeft: textbox.offsetWidth + 'px'
					});
				}
			});*/


			$.fn.modal.Constructor.prototype.enforceFocus = function () { };
			jQuery.validator.addMethod("checkCustomReminder", function( value, element ) {
				if(value != "" && $('#start_date_time').val() != '')
				{
					let dt1 = value.toDate("dd/mm/yyyy hh:ii");
					let dt2 = $('#start_date_time').val().toDate("dd/mm/yyyy hh:ii");
					let subsec = dt1 - dt2;
					if(subsec >= 0){
						return false;
					}else{
						return true;
					}
				}
			}, "Reminder date time must appear before start date time.");
			$("#frmAddEditEvent").validate({
				ignore: [],
				rules: {
					debug: true,
					/*'task_owner[]':
					{
						required: true
					},*/
					fk_evt_type_id:
					{
						required: true
					},
					evt_title:
					{
						required: true
					},
					start_date_time:
					{
						required: true
					},
					reminder_datetime:
					{
						required: function(){ return ($('#evt_reminder_min').val() === 'Custom')},
						checkCustomReminder : function(){ return ($('#evt_reminder_min').val() === 'Custom')}

					}


				},
				messages: {
					/*evt_cust_id:
					{
						required: 'Please select Client'
					},*/
					/*'task_owner[]':
					{
						required: 'Please select user to assign the task'
					},*/
					fk_evt_type_id:
					{
						required: 'Please select Event Type'
					},
					evt_title:
					{
						required: 'Please enter Task Name'
					},
					start_date_time:
					{
						required: 'Please enter Due Point'
					},
					reminder_datetime:
					{
						required: "Please enter reminder date time"

					}
				}
			});
		}
	});

}

function saveEvent() 
{
	if ($('#frmAddEditEvent').valid()) {
		$('#btnSave1').hide();
		$('#btnWait1').show();
		$.ajax({
			type: 'POST',
			url: SYSLINK + 'work_diary.php',
			data: $('#frmAddEditEvent').serialize(),
			dataType: "json",
			success: function (data) {
				if (data.result == 'Success') {
					$('#divModal').modal('hide');
					$('#divModal').html('');
					getWorkDiaryList();
					lobinotify('success', "Task saved successfully.");
				}
				else {
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

function deleteEvent(evt_id) 
{
	Lobibox.confirm({
		msg: "Are you sure, you want to delete Event?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				$.ajax({
					type: "POST",
					url: SYSLINK + 'work_diary.php',
					data: { todo: "deleteEvent", evt_id: evt_id },
					dataType: "json",
					success: function (data) {
						if (data.result == "Success") {
							$('#divModal').modal('hide');
							$('#divModal').html('');
							getWorkDiaryList();
							lobinotify('success', "Event deleted successfully.");
						}
						else {
							lobinotify('error', "Sorry, some problem occurred while saving data.");
						}
					}
				});
			}
		}
	});
}

function triggerEndDate(fullDay) 
{
	if (fullDay.value == 1) {
		$('#block_evt_end_date_time').hide();
	}
	else {
		$('#block_evt_end_date_time').show();
	}
}

function updateEventStatus(evt_id) 
{
	Lobibox.confirm({
		msg: "Are you sure you want to update status of this task?",
		callback: function ($this, type, ev) {
			if (type === "yes") {
				
				$.ajax({
					type: "POST",
					url: SYSLINK + 'work_diary.php',
					data: { todo: "updateEventStatus", evt_id: evt_id },
					dataType: "html",
					success: function (data) {
						$('#divModal').html(data);
						$('#divModal').modal('show');
					}
				});
			}
		}
	});

}

function saveEventStatus() 
{
	$('#btnSave').hide();
	$('#btnWait').show();
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'work_diary.php',
		data: $('#frmEditEventStatus').serialize(),
		dataType: "json",
		success: function (data) {
			if (data.result == 'Success') {
				$('#divModal').modal('hide');
				$('#divModal').html('');
				getWorkDiaryList();
				lobinotify('success', "Task status saved sucessfully.");
			}
			else {
				lobinotify('error', "Sorry, some problem occurred while saving data.");
			}
		}
	});
}

function filterBy(val) 
{
	if (val == 'week') {
		var curr_date = new Date();
		var day = curr_date.getDay();
		var diff = curr_date.getDate() - day + (day == 0 ? -6 : 1); // 0 for sunday
		var week_start_tstmp = curr_date.setDate(diff);
		var week_start = new Date(week_start_tstmp);
		var week_start_date = formatted_date(week_start);
		var week_end = new Date(week_start_tstmp);  // first day of week 
		week_end = new Date(week_end.setDate(week_end.getDate() + 6));
		var week_end_date = formatted_date(week_end);
		date = week_start_date + ' - ' + week_end_date;    // date range for current week

		$("#dateRange1").val(date);

	}
	else if (val == 'month') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), 1);

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth() + 1, 0);

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month
		$("#dateRange1").val(date);

	}
	else if (val == 'today') {
		var curr_date = new Date();

		var first_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var last_day = new Date(curr_date.getFullYear(), curr_date.getMonth(), curr_date.getDate());

		var month_start_date = formatted_date(first_day);

		var month_end_date = formatted_date(last_day);

		date = month_start_date + ' - ' + month_end_date; // date range for current month

		$("#dateRange1").val(date);

	}

	$("#action").val(val);
	getWorkDiaryList();
}

function addNewCustomer(val) 
{
	$.ajax({
		type: 'POST',
		url: SYSLINK + 'customer.php',
		data: { todo: 'addEditCustomer', cust_id: 0 },
		dataType: "html",
		success: function (data) {
			$('#divModal_1').html(data);
			$('#divModal_1').modal('show');
			var select = $('#cust_title').select2();
			$.fn.modal.Constructor.prototype.enforceFocus = function () { };
			$("#frmAddEditCustomer").validate({
				rules: {
					debug: true,

					cust_company:
					{
						required: true
					},
					cust_title:
					{
						required: true
					},
					cust_first_name:
					{
						required: true
					},
					cust_last_name:
					{
						required: true
					},
					cust_source_id:
					{
						required: true
					},

					cust_postcode:
					{
						required: true
					},
					cust_addr1:
					{
						required: true
					},
					cust_town:
					{
						required: true
					},
					cust_telephone:
					{
						number: true
					},
					cust_mobile:
					{
						number: true,
					},
					cust_email_id:
					{
						email: true
					},
					cust_is_active:
					{
						required: true
					},

				},
				messages: {
					cust_company:
					{
						required: "Please enter Company Name"
					},
					cust_title:
					{
						required: 'Please select Title'
					},
					cust_first_name:
					{
						required: 'Please enter First Name'
					},
					cust_last_name:
					{
						required: 'Please enter Last Name'
					},
					cust_source_id:
					{
						required: 'Please select Source'
					},
					cust_postcode:
					{
						required: 'Please enter Postcode'
					},

					cust_addr1:
					{
						required: 'Please enter Address 1'
					},
					cust_town:
					{
						required: 'Please enter Town'
					},
					cust_is_active:
					{
						required: 'Please select Is Active'
					}
				}
			});
		}
	});
}

function saveCustomer() 
{
	if ($('#frmAddEditCustomer').valid()) {
		$('#btnSave').hide();
		$('#btnWait').show();
		$.ajax({
			type: 'POST',
			url: SYSLINK + 'customer.php',
			data: $('#frmAddEditCustomer').serialize(),
			dataType: "json",
			success: function (data) {
				if (data.result == 'Success') {
					$('#divModal_1').modal('hide');
					$('#divModal_1').html('');
					$("#evt_cust_id").html(data.customer_dropdown);
					var select = $('#evt_cust_id').select2();
					//$("#evt_cust_id").val(data.id);
					//$("#s2id_evt_cust_id").val(data.id);
					//getCustomerList();
				}
				else {
					lobinotify('error', "Sorry, some problem occurred while saving data.");
				}
			}
		});
	}
}

var formatted_date = function (date) 
{
	var m = ("0" + (date.getMonth() + 1)).slice(-2); // in javascript month start from 0.
	var d = ("0" + date.getDate()).slice(-2); // add leading zero 
	var y = date.getFullYear();
	return m + '/' + d + '/' + y;
}

function setCustomReminder()
{
	if($('#evt_reminder_min').val() == 'Custom'){
		$('#divCustomReminder').show();
	}else{
		$('#divCustomReminder').hide();
	}
}